package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.tour.biz.TourGoodSpeBiz;
import com.xxfc.platform.tour.common.TourBaseController;
import com.xxfc.platform.tour.dto.TourSpePriceDTO;
import com.xxfc.platform.tour.vo.TourSpePriceVo;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("spe")
@IgnoreClientToken
public class TourGoodSpeController extends TourBaseController<TourGoodSpeBiz> {



    //获取价格
    @RequestMapping(value = "/user/prices", method = RequestMethod.POST)
    public ObjectRestResponse<TourSpePriceVo> prices(@RequestBody TourSpePriceDTO priceDto) {
        return baseBiz.getPricesByuserid(priceDto);
    }

    //减库存
    @RequestMapping(value = "/stock", method = RequestMethod.GET)
    public ObjectRestResponse<TourSpePriceVo> stock(
            @RequestParam(value = "speId",defaultValue = "0")Integer speId,
            @RequestParam(value = "number",defaultValue = "0") Integer number){
        return   baseBiz.cutStock(speId,number);
    }

}