package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.BaseResponse;
import com.github.wxiaoqi.security.common.msg.ListRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.biz.TourGoodBiz;
import com.xxfc.platform.tour.entity.TourGood;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("tourGood")
public class TourGoodController extends BaseController<TourGoodBiz, TourGood> {

    /**
     * 查询旅游路线列表
     *
     * @param page
     * @param limit
     * @param query
     * @param latitude
     * @param longitude
     * @param tagId
     * @param distance
     * @return
     */
    @ApiOperation("查询旅游路线列表")
    @RequestMapping(value = "/app/unauth/getGoodList", method = RequestMethod.GET)
    @IgnoreClientToken
    @ResponseBody
    public PageDataVO<TourGood> getGoodList(@RequestParam(value = "page", required = true) Integer page, @RequestParam(value = "limit", required = true) Integer limit,
                                            @RequestParam(value = "query") String query, @RequestParam(value = "latitude", required = false) Double latitude,
                                            @RequestParam(value = "longitude", required = false) Double longitude, @RequestParam(value = "tagId", required = false) Integer tagId,
                                            @RequestParam(value = "distance", defaultValue = "10.00") Double distance) {
        return baseBiz.getGoodList(page, limit, query, latitude, longitude, tagId, distance);
    }
}