package com.xxfc.platform.tour.mapper;

import com.xxfc.platform.tour.entity.TourTag;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;
import java.util.Map;

/**
 * 旅游路线标签
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Repository
public interface TourTagMapper extends Mapper<TourTag> {
    @Select("select * from tour_tag where is_del=${isDel} and is_hot=${isHot} order by rank ASC")
    List<TourTag> findHotListTag(TourTag tag);

    @Select("select * from tour_tag where is_del=${isDel} order by rank ASC")
    List<TourTag> findAllByIsDel(TourTag tagBanner);
}
