package com.xxfc.platform.tour.biz;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.tour.dto.TourSpePriceDTO;
import com.xxfc.platform.tour.entity.TourGoodSpePrice;
import com.xxfc.platform.tour.mapper.TourGoodSpePriceMapper;
import com.xxfc.platform.tour.vo.TourSpePriceVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * 旅游商品规格表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Service
@Slf4j
public class TourGoodSpeBiz extends BaseBiz<TourGoodSpePriceMapper, TourGoodSpePrice> {

    public ObjectRestResponse<TourSpePriceVo> getPricesByuserid(TourSpePriceDTO priceDto) {
        if (priceDto == null || priceDto.getUserId() == null || priceDto.getUserId() == 0 ||
                priceDto.getNumber() == null || priceDto.getNumber() == 0||priceDto.getSpeId()==null) {
            return ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        TourSpePriceVo priceVo = new TourSpePriceVo();
        Integer speId = priceDto.getSpeId();
        Integer number = priceDto.getNumber();
        Integer childNumber = priceDto.getChildNumber() == null ? 0 : priceDto.getChildNumber();
        if (speId != null) {
            TourGoodSpePrice spePrice = mapper.selectByPrimaryKey(speId);
            if (spePrice != null) {
                Integer level = priceDto.getLevel();
                priceVo.setUserId(priceDto.getUserId());
                priceVo.setLevel(priceDto.getLevel());
                priceVo.setStock(spePrice.getStock());
                BigDecimal price = spePrice.getPrice();
                BigDecimal childPrice = spePrice.getChildPrice();
                priceVo.setOriginalPrice(price);
                priceVo.setChildOriginalPrice(childPrice);
                BigDecimal totalPrice = price.multiply(new BigDecimal(number)).setScale(2, RoundingMode.HALF_UP);
                BigDecimal totalChildPrice = childNumber > 0 ? price.multiply(new BigDecimal(childNumber)).setScale(2, RoundingMode.HALF_UP): new BigDecimal("0.00");
                priceVo.setTotalPrice(totalPrice);
                priceVo.setTotalChildPrice(totalChildPrice);
                if (level != null && level > 0) {
                    String memberPrice = spePrice.getMemberPrice();
                    JSONArray array = JSONArray.parseArray(memberPrice);
                    if (array.size() > 0) {
                        for (Object obj : array) {
                            JSONObject jsonObject = JSONObject.parseObject(obj.toString());
                            Integer levels = jsonObject.getInteger("level");
                            if (level == levels) {
                                String money = jsonObject.getString("price");
                                price = new BigDecimal(StringUtils.isNotBlank(money) ? money : "0.00");
                                String childMoney = jsonObject.getString("child_price");
                                childPrice = new BigDecimal(StringUtils.isNotBlank(childMoney) ? childMoney : "0.00");
                                break;
                            }
                        }
                    }
                }
                    totalPrice = price.multiply(new BigDecimal(number)).setScale(2, RoundingMode.HALF_UP);
                    totalChildPrice = childNumber > 0 ? price.multiply(new BigDecimal(childNumber)).setScale(2, RoundingMode.HALF_UP): new BigDecimal("0.00");
                    priceVo.setPrice(price);
                    priceVo.setChildPrice(childPrice);
                    priceVo.setRealPrice(totalPrice);
                    priceVo.setRealChildPrice(totalChildPrice);
                    return ObjectRestResponse.succ(priceVo);
                }
            }
            return ObjectRestResponse.createDefaultFail();

        }

        //减库存
       public  ObjectRestResponse cutStock(Integer speId,Integer number) {
           TourGoodSpePrice spePrice = mapper.selectByPrimaryKey(speId);
           if (spePrice != null && spePrice.getStock() > 0 && spePrice.getStock() >= number) {
               mapper.updStockById(speId, number);
               return ObjectRestResponse.succ();
           } else {
               return ObjectRestResponse.createFailedResult(ResultCode.STOCK_CODE, "库存不足");
           }
       }


}