package com.xxfc.platform.tour.biz;

import com.ace.cache.annotation.Cache;
import com.ace.cache.annotation.CacheClear;
import com.xxfc.platform.tour.comstnt.RedisKey;
import com.xxfc.platform.tour.mapper.TourBannerMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import com.xxfc.platform.tour.entity.TourBanner;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.List;

/**
 * 首页banner图
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Service
public class TourBannerBiz extends BaseBiz<TourBannerMapper,TourBanner> {

    @Autowired
    private RedisTemplate redisTemplate;

    @Cache(key = RedisKey.CONSTANT_CODE_PREFIX_BANNER)
    public List<TourBanner> findBannerList() {

        TourBanner banner = new TourBanner();
        banner.setIsDel(0);
        return  mapper.findBannerListByisDelOrderByRank(banner);
    }


    @CacheClear(key = RedisKey.CONSTANT_CODE_PREFIX_BANNER)
    public void update(TourBanner banner) {
      this.updateSelectiveById(banner);
    }


    @CacheClear(key = RedisKey.CONSTANT_CODE_PREFIX_BANNER)
    public void remove(int id) {
        this.deleteById(id);
    }

}