package com.xxfc.platform.tour.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 旅游商品规格表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
@Table(name = "tour_good_spe")
public class TourGoodSpe implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    //商品id
    @Column(name = "good_id")
	@ApiModelProperty(value = "商品id")
    private Integer goodId;
	
	    //规格名
    @Column(name = "title")
	@ApiModelProperty(value = "规格名")
    private String title;
	
	    //父id
    @Column(name = "parent_id")
	@ApiModelProperty(value = "父id")
    private Integer parentId;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    //更新时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    //是否删除:0-正常；1-删除
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除:0-正常；1-删除")
    private Integer isDel;
	

}
