package com.xxfc.thirdparty.api;

import com.xxfc.thirdparty.model.JuheResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient("xx-third-party")
@RequestMapping("3p/tv")
public interface ITrafficViolationsService {

    /**
     * 获取支持的城市
     * @param province
     * @return
     */
    @RequestMapping(value = "city", method = RequestMethod.GET)
    JuheResult getCityInfo(String province);

    /**
     * 查违章
     * @param city 城市代码
     * @param hphm 车牌号码
     * @param hpzl 车辆类型 01：大车，02：小车
     * @param engineno 发动机号
     * @param classno 车架号
     * @return
     */
    @RequestMapping(value = "trafficViolations", method = RequestMethod.GET)
    JuheResult queryTrafficViolations(String city, String hphm, String hpzl, String engineno, String classno);

    /**
     * 获取剩余查询次数
     * @return
     */
    @RequestMapping(value = "balance", method = RequestMethod.GET)
    JuheResult getBalance();

    /**
     * 根据车牌查归属地
     * @param hphm 车牌号码
     * @return
     */
    @RequestMapping(value = "carPre", method = RequestMethod.GET)
    JuheResult carPre(String hphm);
}
