package com.xxfc.platform.order.rest;

import cn.hutool.core.bean.BeanUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.order.biz.OrderTourDetailBiz;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.entity.OrderTourDetail;
import com.xxfc.platform.order.pojo.AddRentVehicleDTO;
import com.xxfc.platform.order.pojo.AddTourDTO;
import com.xxfc.platform.order.pojo.order.RentVehicleBO;
import com.xxfc.platform.order.pojo.order.TourBO;
import com.xxfc.platform.order.pojo.price.RentVehiclePriceVO;
import com.xxfc.platform.order.pojo.price.TourPriceVO;
import com.xxfc.platform.order.service.OrderTourService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.persistence.Column;

@Controller
@RequestMapping("orderTour")
@Api(value="旅游订单",tags={"旅游订单"})
public class OrderTourController extends BaseController<OrderTourDetailBiz,OrderTourDetail> {

    @Autowired
    OrderTourService orderTourService;

    @RequestMapping(value = "add",method = RequestMethod.POST)
    @ResponseBody
    @ApiOperation(value = "确认旅游订单")
    public ObjectRestResponse<BaseOrder> add(@RequestBody AddTourDTO vo){
        TourBO bo = BeanUtil.toBean(vo, TourBO.class);
        orderTourService.createOrder(bo);
        return ObjectRestResponse.succ(bo.getOrder());
    }

    @RequestMapping(value = "/app/unauth/calculate-price",method = RequestMethod.GET)
    @ResponseBody
    @ApiOperation(value = "价格计算")
    @IgnoreUserToken
    public ObjectRestResponse<TourPriceVO> calculatePrice(CalculatePriceVO vo){
        TourBO bo = BeanUtil.toBean(vo, TourBO.class);
        return ObjectRestResponse.succ(orderTourService.calculatePrice(bo));
    }

    @Data
    public class CalculatePriceVO {
        //商品id
        @ApiModelProperty(value = "商品id")
        private Integer goodId;

        //商品规格ids
        @ApiModelProperty(value = "商品规格ids")
        private String speIds;

        //具体商品（商品项）id
        @ApiModelProperty(value = "具体商品（商品项）id")
        private String spePriceId;

        //自己乘客ids
        @ApiModelProperty(value = "自己乘客ids")
        private String tourUserIds;
    }
}