package com.xxfc.platform.order.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@Data
public class AddTourDTO {
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    //开始时间
    @Column(name = "start_time")
    @ApiModelProperty(value = "活动开始时间")
    private Long startTime;

    //结束时间
    @Column(name = "end_time")
    @ApiModelProperty(value = "活动结束时间")
    private Long endTime;

    //天数
    @Column(name = "day_num")
    @ApiModelProperty(value = "天数")
    private Integer dayNum;

    //取车地点
    @Column(name = "start_addr")
    @ApiModelProperty(value = "出发地点")
    private String startAddr;

    //还车地点
    @Column(name = "end_addr")
    @ApiModelProperty(value = "结束地点")
    private String endAddr;

    //费用详情
    @Column(name = "cost_detail")
    @ApiModelProperty(value = "费用详情")
    private String costDetail;

    //取车城市编号
    @Column(name = "start_city")
    @ApiModelProperty(value = "出发城市编号")
    private Integer startCity;

    //还车城市编号
    @Column(name = "end_city")
    @ApiModelProperty(value = "结束城市编号")
    private Integer endCity;

    //取车城市名称
    @Column(name = "start_city_name")
    @ApiModelProperty(value = "出发城市名称")
    private String startCityName;

    //还车城市名称
    @Column(name = "end_city_name")
    @ApiModelProperty(value = "结束城市名称")
    private String endCityName;

    //自己乘客ids
    @Column(name = "my_passager_ids")
    @ApiModelProperty(value = "自己乘客ids")
    private String myPassagerIds;

    //出发公司Id
    @Column(name = "start_company_id")
    @ApiModelProperty(value = "出发公司Id")
    private Integer startCompanyId;

    //商品id
    @Column(name = "good_id")
    @ApiModelProperty(value = "商品id")
    private Integer goodId;

    //商品规格ids
    @Column(name = "spe_ids")
    @ApiModelProperty(value = "商品规格ids")
    private String speIds;

    //具体商品（商品项）id
    @Column(name = "spe_price_id")
    @ApiModelProperty(value = "具体商品（商品项）id")
    private String spePriceId;
}
