package com.xxfc.platform.vehicle.mapper;

import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.pojo.AddOrUpdateVehicleVo;
import com.xxfc.platform.vehicle.pojo.QueryVehicleVo;
import com.xxfc.platform.vehicle.pojo.UsableVehicleModelVO;
import org.springframework.data.repository.query.Param;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;
import java.util.Map;

public interface VehicleMapper extends Mapper<Vehicle> {

    public List<QueryVehicleVo> getByPage(Map<String, Object> params);
    public List<QueryVehicleVo> getByPageNotAllData(Map<String, Object> params);

    public int updateStatusById(Map<String, Object> params);

    /**
     * 锁定相关编码 或 车牌 的行
     * @param addOrUpdateVehicleVo
     * @return
     */
    public List<Vehicle> lockByCode(AddOrUpdateVehicleVo addOrUpdateVehicleVo);

    int updateStatusByIdAndStatus(@Param("vehicleId") String vehicleId, @Param("status") Integer status,
                                  @Param("lastStatus") Integer lastStatus);

    Vehicle selectByNumberPlate(String numberPlate);

    List<UsableVehicleModelVO> searchUsableModel(Map<String, Object> params);

    List<Vehicle> searchUsableVehicle(Map<String, Object> params);
}