package com.xxfc.platform.vehicle.common;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;

@Slf4j
public class VehicleBaseController<Biz extends BaseBiz> {
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected Biz baseBiz;
    @Autowired
    protected UserFeign userFeign;
    @Autowired
    protected UserAuthConfig userAuthConfig;

  public AppUserDTO getUserInfo(){
      return  userFeign.userDetailByToken(userAuthConfig.getToken(request)).getData();
  }


}
