package com.xxfc.platform.campsite.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 店铺类型表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Data
@Table(name = "campsite_tag")
public class CampsiteTag implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键id")
    private Integer id;

    /**
     * 父id
     */
    @Column(name = "parent_id")
    @ApiModelProperty(value = "父id")
    private Integer parentId;

    /**
     * 名称
     */
    @Column(name = "name")
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 是否筛选条件
     */
    @Column(name = "is_search")
    @ApiModelProperty(value = "是否筛选条件")
    private Integer isSearch;

    /**
     * 排序
     */
    @Column(name = "rank")
    @ApiModelProperty(value = "排序")
    private Integer rank;

    /**
     * 创建时间
     */
    @Column(name = "ctr_time")
    @ApiModelProperty(value = "创建时间")
    private Long ctrTime;

    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    @ApiModelProperty(value = "更新时间", hidden = true)
    private Long updTime;

    /**
     * 是否删除:0-正常；1-删除
     */
    @Column(name = "is_del")
    @ApiModelProperty(value = "是否删除:0-正常；1-删除")
    private Integer isDel;


}
