package com.xxfc.platform.user.behavior.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.user.behavior.biz.CustomerBehaviorNotesBiz;
import com.xxfc.platform.user.behavior.common.IdentityEnum;
import com.xxfc.platform.user.behavior.dto.CustomerBehaviorNoteDTO;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

/**
 * @author libin
 * @version 1.0
 * @description 用户行为日志*记录
 * @data 2019/8/12 14:14
 */
@RestController
@RequestMapping("customerBehaviorNotes")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class CustomerBehaviorNotesController {

    private final CustomerBehaviorNotesBiz customerBehaviorNotesBiz;

    @PostMapping("app/unauth/save")
    public ObjectRestResponse<Void> saveCustomerBehavior(@RequestBody CustomerBehaviorNoteDTO customerBehaviorNoteDTO, AppUserDTO appUserDTO) {
        if (Objects.nonNull(appUserDTO.getUserid())) {
            customerBehaviorNoteDTO.setCustomerId(String.valueOf(appUserDTO.getUserid()));
            customerBehaviorNoteDTO.setCustomerType(IdentityEnum.USER.getCode());
        }else {
            customerBehaviorNoteDTO.setCustomerType(IdentityEnum.VISITOR.getCode());
        }
        customerBehaviorNotesBiz.saveCustomerBehavior(customerBehaviorNoteDTO);
        return ObjectRestResponse.succ();
    }
}