package com.xxfc.platform.user.behavior.biz;

import com.xxfc.platform.user.behavior.dto.CustomerBehaviorNoteDTO;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import com.xxfc.platform.user.behavior.entity.CustomerBehaviorNotes;
import com.xxfc.platform.user.behavior.mapper.CustomerBehaviorNotesMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.time.Instant;

/**
 * 用户行为记录表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-08-12 14:03:55
 */
@Service
public class CustomerBehaviorNotesBiz extends BaseBiz<CustomerBehaviorNotesMapper,CustomerBehaviorNotes> {

    public void saveCustomerBehavior(CustomerBehaviorNoteDTO customerBehaviorNoteDTO) {
        CustomerBehaviorNotes customerBehaviorNotes = new CustomerBehaviorNotes();
        BeanUtils.copyProperties(customerBehaviorNoteDTO,customerBehaviorNotes);
        customerBehaviorNotes.setCrtTime(Instant.now().toEpochMilli());
        mapper.insertSelective(customerBehaviorNotes);
    }
}