package com.xxfc.platform.user.behavior.common;

/**
 * @author libin
 * @version 1.0
 * @description 用户行为枚举
 * @data 2019/8/12 14:57
 */
public enum BehaviorEnum {

    /**
     * 弹窗曝光
     */
    DIALOG_WINDOW(0, "弹窗曝光"),

    /**
     * 立即前往（弹窗）
     */
    DIALOG_WINDOW_TO(1, "立即前往"),

    /**
     * banner 点击
     */
    BANNER_CLICK(2, "banner点击"),

    /**
     * 精彩活动点击
     */
    WONDERFUL_ACTIVITY_CLICK(3, "精彩活动点击"),

    /**
     * 注册
     */
    REGISTRY(4, "注册"),

    /**
     * 领取任务
     */
    CLAIM_TASK(5, "领取任务"),

    /**
     * 分享
     */
    SHARE(6, "分享"),

    /**
     * 邀请
     */
    INVITATION(7, "邀请");

    BehaviorEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    private int code;

    private String name;

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
