package com.xxfc.platform.campsite.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author libin
 * @version 1.0
 * @description TODO
 * @data 2019/6/17 17:35
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CampsiteShopDetailDTO {
    /**
     * 店铺名称
     */
    @ApiModelProperty("店铺名称")
    private String name;

    /**
     * 地址-省/直辖市(名称)
     */
    @ApiModelProperty("地址-省/直辖市(名称)")
    private String provinceName;

    /**
     * 地址-市(名称)
     */
    @ApiModelProperty("地址-市(名称)")
    private String cityName;

    /**
     * 具体地址
     */
    @ApiModelProperty("具体地址")
    private String address;

    /**
     * 店铺详情
     */
    @ApiModelProperty("店铺详情")
    private String content;

    /**
     * 配套设施&收费
     */
    @ApiModelProperty("配套设施&收费")
    private String configure;

    /**
     * 经度
     */
    @ApiModelProperty(value = "经度")
    private Double longitude;

    /**
     * 纬度
     */
    @ApiModelProperty(value = "纬度")
    private Double latitude;

    @ApiModelProperty(value = "电话")
    private String phone;

    /**
     * 店铺logo
     */
    private String logo;

}
