package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleCountRecordBiz;
import com.xxfc.platform.vehicle.entity.VehicleCountRecord;
import com.xxfc.platform.vehicle.pojo.ExcelParamDto;
import com.xxfc.platform.vehicle.util.excel.DownloadUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;

@Controller
@RequestMapping(value = "/vehicleCount")
public class VehicleCountRecordController {

    @Autowired
    VehicleCountRecordBiz vehicleCountRecordBiz;

    @GetMapping("/app/unauth/test")
    @ResponseBody
    public ObjectRestResponse add() {
        vehicleCountRecordBiz.add();
        return ObjectRestResponse.succ();
    }

    @GetMapping("/app/unauth/get")
    @ResponseBody
    public ObjectRestResponse getByTypeAndDate(VehicleCountRecord vehicleCountRecord) {
        return vehicleCountRecordBiz.countDepartureVehicle(vehicleCountRecord);
    }

    @PostMapping("/app/unauth/export")
    @ResponseBody
    public ObjectRestResponse export(@RequestBody ExcelParamDto excelParamDto, HttpServletRequest request) {
        return vehicleCountRecordBiz.export(excelParamDto, request);
    }

    @GetMapping("/app/unauth/download")
    public void download(ExcelParamDto excelParamDto, HttpServletRequest request,HttpServletResponse response) {
        DownloadUtil.downloadFile(excelParamDto.getPath(), "export.xls", response,request);
    }
}
