package com.xxfc.platform.order.pojo.order;

import com.xxfc.platform.activity.entity.Coupon;
import com.xxfc.platform.order.entity.*;
import com.xxfc.platform.order.pojo.OrderAccompanyDTO;
import com.xxfc.platform.vehicle.entity.VehicleUserLicense;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Data
public class OrderListVo extends BaseOrder {

    OrderRentVehicleDetail orderRentVehicleDetail;

    OrderTourDetail orderTourDetail;

    OrderMemberDetail orderMemberDetail;

    List<VehicleUserLicense> vehicleUserLicenses;

    private String username;

    private String vehicleNumberPlat;

    private String telephone;

    private OrderVehicleCrosstownDto orderVehicleCrosstownDto;

    private String startCompanyName;

    private String endCompanyName;

    private String realName;
    /**
     * 是否是用户匹配公司
     */
    private boolean userCompanyStatus = false;

    /**
     * 违章预备金
     */
    private BigDecimal illegalReserve;


    private List<OrderItem> items;


    @ApiModelProperty(value = "用户职位名称")
    private String jobTitle;

    @ApiModelProperty(value = "用户会员名称")
    private String memberName;

    @ApiModelProperty(value = "随车物品")
    private String  carArticlesJson;


    @ApiModelProperty(value = "使用优惠卷")
    ArrayList<Coupon> couponList ;

    @ApiModelProperty(value = "退还优惠卷")
    ArrayList<Coupon> backCouponList;
}
