package com.xxfc.platform.order.biz;

import cn.hutool.json.JSONUtil;
import com.github.wxiaoqi.security.admin.dto.UserMemberDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.OrderUtil;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderAccount;
import com.xxfc.platform.order.entity.OrderItem;
import com.xxfc.platform.order.entity.OrderMemberDetail;
import com.xxfc.platform.order.mapper.OrderMemberDetailMapper;
import com.xxfc.platform.order.pojo.order.add.AddMemberDTO;
import com.xxfc.platform.universal.feign.MQSenderFeign;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/**
 * 
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-19 17:00:35
 */
@Service
@Slf4j
public class OrderMemberDetailBiz extends BaseBiz<OrderMemberDetailMapper,OrderMemberDetail> implements UserRestInterface {

	@Autowired
	UserFeign userFeign;

	@Autowired
	BaseOrderBiz baseOrderBiz;

	@Autowired
	MQSenderFeign mqSenderFeign;

	@Autowired
	OrderItemBiz orderItemBiz;

	@Autowired
	OrderAccountBiz orderAccountBiz;

	/**
	 * 后台创建订单
	 * @param dto
	 */
	public void createOrder(AddMemberDTO dto) {
		UserDTO userDTO = getAdminUserInfo();
		if (userDTO == null) {
			throw new BaseException(ResultCode.getMsg(ResultCode.RSTOKEN_EXPIRED_CODE));
		}
		AppUserLogin appUserLogin = userFeign.one(dto.getPhone());
		if (appUserLogin != null) {
			List<BaseUserMemberLevel> baseUserMemberLevelList = userFeign.levels();
			if (baseUserMemberLevelList != null && baseUserMemberLevelList.size() > 0) {
				BaseOrder baseOrder = new BaseOrder();
				AtomicReference<BaseUserMemberLevel> currentLevel = new AtomicReference<>();
				baseUserMemberLevelList.parallelStream().forEach(baseUserMemberLevel -> {
					if (dto.getMemberLevel().equals(baseUserMemberLevel.getLevel())) {
						currentLevel.set(baseUserMemberLevel);
					}
				});
				if (currentLevel != null && currentLevel.get() != null) {
					BaseUserMemberLevel baseUserMemberLevel = currentLevel.get();
					baseOrder.setNo(OrderUtil.GetOrderNumber("", OrderUtil.APP_MID));
					baseOrder.setUserId(appUserLogin.getId());
					baseOrder.setGoodsAmount(dto.getOrderAmount());
					baseOrder.setOrderAmount(dto.getOrderAmount());
					baseOrder.setRealAmount(dto.getOrderAmount());
					baseOrder.setStatus(OrderStatusEnum.ORDER_FINISH.getCode());
					baseOrder.setName(baseUserMemberLevel.getName());
					if (dto.getPayTime() != null) {
						baseOrder.setPayTime(dto.getPayTime());
					} else {
						baseOrder.setPayTime(System.currentTimeMillis());
					}
					baseOrder.setType(OrderTypeEnum.MEMBER.getCode());
					baseOrder.setHasPay(1);
					baseOrder.setOrderOrigin(3);
					baseOrder.setCrtUser(userDTO.getUsername());
					baseOrder.setCrtName(userDTO.getName());
					baseOrder.setVersion(1);
					baseOrder.setCrtTime(new Date(baseOrder.getPayTime()));
					baseOrderBiz.insertSelectiveRe(baseOrder);
					OrderMemberDetail orderMemberDetail = new OrderMemberDetail();
					orderMemberDetail.setOrderId(baseOrder.getId());
					orderMemberDetail.setMemberLevel(baseUserMemberLevel.getLevel());
					orderMemberDetail.setMemberLevelId(baseUserMemberLevel.getId());
					orderMemberDetail.setName(baseUserMemberLevel.getName());
					orderMemberDetail.setRebate(baseUserMemberLevel.getDiscount());
					orderMemberDetail.setRentFreeNum(baseUserMemberLevel.getNumber());
					insertSelectiveRe(orderMemberDetail);
					baseOrder.setDetailId(orderMemberDetail.getId());
					baseOrderBiz.updateSelectiveByIdRe(baseOrder);

					OrderItem orderItem = new OrderItem();
					orderItem.setOrderId(baseOrder.getId());
					orderItem.setName(baseOrder.getName());
					orderItem.setBuyNum(1);
					orderItem.setAwardNum(1);
					orderItem.setType(6);
					orderItem.setMetaUnitPrice(baseUserMemberLevel.getPrice());
					orderItem.setUnitPrice(baseUserMemberLevel.getPrice());
					orderItem.setTotalNum(1);
					orderItem.setBuyNum(1);
					orderItem.setAwardNum(0);
					orderItem.setCutNum(0);
					orderItem.setGoodId(baseUserMemberLevel.getId());
					orderItemBiz.insertSelectiveRe(orderItem);
					OrderAccount orderAccount = new OrderAccount();
					orderAccount.setAccountAmount(baseOrder.getOrderAmount());
					orderAccount.setOrderId(baseOrder.getId());
					orderAccount.setTradeNo(baseOrder.getNo());
					orderAccount.setAccountTime(System.currentTimeMillis());
					orderAccount.setAccountType(101);
					orderAccount.setAccountStatus(1);
					orderAccount.setAccountDesc("会员订单支付");
					orderAccount.setAccountDesc("{\"depositAmount\":0,\"orderAmount\":"+ baseOrder.getOrderAmount() + ",\"originDepositAmount\":0,\"originOrderAmount\":"+ baseOrder.getOrderAmount() + ",\"deductions\":[]}");
					orderAccount.setOriginalAmount(baseOrder.getOrderAmount());
					orderAccount.setDeductAmount(BigDecimal.ZERO);
					orderAccountBiz.insertSelectiveRe(orderAccount);
					//触发会员效益
					UserMemberDTO userMemberDTO = new UserMemberDTO() {{
						setUserId(baseOrder.getUserId());
						setIsBind(ISBIND_BIND);
					}};
					userMemberDTO.setMemberLevel(orderMemberDetail.getMemberLevel());
					userMemberDTO.setRentFreeDays(orderMemberDetail.getRentFreeNum());
					userMemberDTO.setTotalNumber(orderMemberDetail.getRentFreeNum());
					userMemberDTO.setDiscount(orderMemberDetail.getRebate());

					ObjectRestResponse orr = userFeign.buyMember(userMemberDTO);
					log.info("orr.getStatus() : " + orr.getStatus());
					//发送消息队列到admin，进行分成计算
					orderMemberDetail.setBaseOrder(baseOrder);
					mqSenderFeign.sendMessage(RabbitConstant.ADMIN_TOPIC, RabbitConstant.KEY_MEMBER_SHARE, JSONUtil.toJsonStr(orderMemberDetail));

				}

			} else {
				throw new BaseException(ResultCode.getMsg(ResultCode.USER_MEMBER_INFO_NOT_EXIST_CODE));
			}
		} else {
			throw new BaseException(ResultCode.getMsg(ResultCode.USER_NOTEXIST_CODE));
		}
	}

	@Override
	public UserFeign getUserFeign() {
		return userFeign;
	}
}