package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.MemberShareRecordBiz;
import com.github.wxiaoqi.security.admin.dto.MemberShareRecordDto;
import com.github.wxiaoqi.security.admin.entity.MemberShareRecord;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

@RestController
@RequestMapping("memberShareRecord")
@Slf4j
public class MemberShareRecordController extends BaseController<MemberShareRecordBiz, MemberShareRecord> {

	/**
	 *  获取用户分成明细
	 * @param memberShareRecordDto
	 * @return
	 */
	@GetMapping(value = "getAllRecord")
	public ObjectRestResponse getAllRecord(MemberShareRecordDto memberShareRecordDto) {
		return baseBiz.getAllRecord(memberShareRecordDto);
	}

	/**
	 * 统计用户分成信息
	 */
	@GetMapping(value = "/app/unauth/generateData")
	public void generateData() {
		baseBiz.generateData();
	}

	@GetMapping(value = "export")
	public ObjectRestResponse export(HttpServletResponse response, MemberShareRecordDto memberShareRecordDto) {
		try {
			baseBiz.exportRecordList(response, memberShareRecordDto);
		} catch (Exception e) {
			log.error("{}", e);
			return ObjectRestResponse.createDefaultFail();
		}
		return ObjectRestResponse.succ();
	}

	@GetMapping(value = "getAllCountRecord")
	public ObjectRestResponse getAllCountRecord(MemberShareRecordDto memberShareRecordDto) {
		return baseBiz.selectCountList(memberShareRecordDto);
	}

	@GetMapping(value = "exportCountRecordList")
	public ObjectRestResponse exportCountRecordList(HttpServletResponse response, MemberShareRecordDto memberShareRecordDto) {
		try {
			baseBiz.exportCountRecordList(response, memberShareRecordDto);
		} catch (Exception e) {
			log.error("{}", e);
			return ObjectRestResponse.createDefaultFail();
		}
		return ObjectRestResponse.succ();
	}
}