package com.github.wxiaoqi.security.admin.biz;

import com.ace.cache.annotation.Cache;
import com.ace.cache.annotation.CacheClear;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.admin.mapper.BaseUserMemberLevelMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.app.entity.Cofig;
import com.xxfc.platform.app.feign.ConfigFeign;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author keliii
 */
@Service
public class UserMemberLevelBiz extends BaseBiz<BaseUserMemberLevelMapper,BaseUserMemberLevel> {


    @Autowired
    ConfigFeign configFeign;


    @Transactional
    @Cache(key="member")
    public List<BaseUserMemberLevel> getLevesls() {
        Example example=new Example(BaseUserMemberLevel.class);
        example.createCriteria().andEqualTo("isdel",0);
        example.setOrderByClause(" level asc ");
        return  mapper.selectByExample(example);
    }

    @Transactional
    public List<BaseUserMemberLevel> getList(BaseUserMemberLevel baseUserMemberLevel) {
        Example example=new Example(BaseUserMemberLevel.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isdel",0);
        if (baseUserMemberLevel.getIsShow() != null){
            criteria.andEqualTo("isShow",baseUserMemberLevel.getIsShow());
        }
        example.setOrderByClause(" level asc ");
        List<BaseUserMemberLevel> list = mapper.selectByExample(example);
        setShowShareAmount(list);
        return list;
    }

    public BaseUserMemberLevel getLevel(Integer level) {
        Example example=new Example(BaseUserMemberLevel.class);
        example.createCriteria().andEqualTo("isdel",0).andEqualTo("level",level);
        List<BaseUserMemberLevel> list=mapper.selectByExample(example);
        if (list.size()>0){
              return  list.get(0);
        }
        return null;
    }


    public  void  setShowShareAmount(List<BaseUserMemberLevel> list){
        if (list.size() > 0){
            BigDecimal price = getConfigParam();
            for (BaseUserMemberLevel memberLevel : list){
                BigDecimal showShareAmount = price.multiply(memberLevel.getShareAmount()).divide(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                memberLevel.setShowShareAmount(showShareAmount);
            }
        }
    }

    public  BigDecimal  getConfigParam(){
        ObjectRestResponse<List<Cofig>> restResponse = configFeign.getAllByType("77");
        BigDecimal price = BigDecimal.ZERO;
        if (restResponse.getData() != null ){
            List<Cofig> cofigList = restResponse.getData();
            JSONObject jsonObject = JSONObject.parseObject(cofigList.get(0).getParams());
            price = jsonObject.getBigDecimal("price");
        }
        return  price;
    }

    @Transactional(rollbackFor = Exception.class,propagation = Propagation.REQUIRED)
    public Map<Integer, BaseUserMemberLevel> getUserMemberLevelAndUserMemberMapByLevels(List<Integer> levels){
       List<BaseUserMemberLevel> baseUserMemberLevels = mapper.selectUserMembersLevelByLevels(levels);
        Map<Integer,BaseUserMemberLevel> levelAndDiscountMap = null;
       if (CollectionUtils.isNotEmpty(baseUserMemberLevels)){
           levelAndDiscountMap = baseUserMemberLevels.stream().collect(Collectors.toMap(BaseUserMemberLevel::getLevel, Function.identity()));
       }
       return levelAndDiscountMap;
    }

    @CacheClear(key = "member")
    public void updateMemberBaseInfo(BaseUserMemberLevel baseUserMemberLevel) {
        int affectRows = mapper.updateByPrimaryKeySelective(baseUserMemberLevel);
        if (affectRows==0){
            throw new BaseException("更新会员等级失败");
        }
    }
}
