package com.github.wxiaoqi.security.admin.biz;

import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.github.wxiaoqi.security.admin.dto.MemberShareCountRecordDto;
import com.github.wxiaoqi.security.admin.entity.MemberShareCountRecord;
import com.github.wxiaoqi.security.admin.mapper.MemberShareCountRecordMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.util.*;

/**
 * 会员分成月统计信息
 *
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-11-03 11:12:15
 */
@Service
@Slf4j
public class MemberShareCountRecordBiz extends BaseBiz<MemberShareCountRecordMapper, MemberShareCountRecord> {

	public void batchSave(List<MemberShareCountRecord> list) {
		mapper.batchSave(list);
	}

	/**
	 * 分页查询统计信息
	 * @param memberShareCountRecordDto
	 * @return
	 */
	public ObjectRestResponse selectList(MemberShareCountRecordDto memberShareCountRecordDto) {
		Query query = new Query(memberShareCountRecordDto);
		PageDataVO<MemberShareCountRecord> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectList(query.getSuper()));
		return ObjectRestResponse.succ(pageDataVO);
	}

	/**
	 * 会员分成导出信息
	 * @param httpServletResponse
	 * @param memberShareCountRecordDto
	 * @throws Exception
	 */
	public void exportRecordList(HttpServletResponse httpServletResponse, MemberShareCountRecordDto memberShareCountRecordDto)throws Exception {
		ExcelWriter writer = null;
		try {
			writer = ExcelUtil.getWriter(true);

			//封装表头
			writer.addHeaderAlias("countMonth", "统计月份");
			writer.addHeaderAlias("userId", "用户id");
			writer.addHeaderAlias("realName", "真实姓名");
			writer.addHeaderAlias("amount", "金额");
			//处理数据
			List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
			memberShareCountRecordDto.setLimit(Integer.MAX_VALUE);
			Query query = new Query(memberShareCountRecordDto);
			List<MemberShareCountRecord> memberShareCountRecordList = mapper.selectList(query.getSuper());
			if (memberShareCountRecordList != null && memberShareCountRecordList.size() > 0) {
				for (MemberShareCountRecord memberShareCountRecord : memberShareCountRecordList) {
					Map<String, Object> map = new HashMap();
					map.put("userId", memberShareCountRecord.getUserId());
					map.put("realName", memberShareCountRecord.getRealName());
					map.put("countMonth", memberShareCountRecord.getCountMonth());
					map.put("amount", memberShareCountRecord.getAmount());
					list.add(map);
				}
			}
			if (list.size() == 0) {
				Map<String, Object> map = new HashMap<String, Object>();
				writer.addHeaderAlias("countMonth", "统计月份");
				writer.addHeaderAlias("userId", "用户id");
				writer.addHeaderAlias("realName", "真实姓名");
				writer.addHeaderAlias("amount", "金额");
				map.put("userId", "");
				map.put("realName", "");
				map.put("countMonth", "");
				map.put("amount", "");
				list.add(map);
			}
			writer.write(list);
			httpServletResponse.setContentType("application/octet-stream;charset=utf-8");
			httpServletResponse.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("会员分成明细.xlsx", "utf-8"));
			writer.flush(httpServletResponse.getOutputStream());
		}catch (Exception ex) {
			log.error(ex.getMessage(), ex);
			throw ex;
		}finally {
			if (writer != null) {
				writer.close();
			}
		}
	}

}