package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.biz.OrderRefundBiz;
import com.xxfc.platform.order.biz.inner.OrderCancelBiz;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.OrderRefund;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import com.xxfc.platform.universal.constant.DictionaryKey;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.math.BigDecimal;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;
import static com.xxfc.platform.universal.constant.DictionaryKey.TOUR_IN_REFUND;
import static com.xxfc.platform.universal.constant.DictionaryKey.TOUR_REFUND;

@Controller
@RequestMapping("orderRefund")
public class OrderRefundController extends BaseController<OrderRefundBiz,OrderRefund> implements UserRestInterface {

    @Autowired
    BaseOrderBiz baseOrderBiz;

    @Autowired
    OrderRefundBiz orderRefundBiz;

    @Autowired
    UserFeign userFeign;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }

    @RequestMapping(value = "/price/calculate/{no}", method = RequestMethod.GET)
    @ResponseBody
    @IgnoreClientToken
    public ObjectRestResponse<BigDecimal> getPriceCalculate(@PathVariable(value = "no") String no) {
        checkAppUser();
        //根据no 查订单
        OrderPageVO orderPageVO = baseOrderBiz.pageByParm(new Query(new PageParam(){{
            setLimit(1);
            setPage(1);
        }}){{put("no", no); }}.getSuper()).get(0);

        OrderTypeEnum orderTypeEnum = OrderTypeEnum.get(orderPageVO.getType());

        BigDecimal orderRefundAmount = BigDecimal.ZERO;
        StringBuilder refundDescBuilder = new StringBuilder("");

        switch (orderTypeEnum) {
            case RENT_VEHICLE:
                orderRefundAmount = orderRefundBiz.calculateRefund(orderPageVO.getGoodsAmount().subtract(orderPageVO.getCouponAmount())
                        , orderPageVO.getOrderRentVehicleDetail().getStartTime() - System.currentTimeMillis()
                        , DictionaryKey.APP_ORDER+ "_"+ DictionaryKey.RENT_REFUND
                        , refundDescBuilder);
                break;
            case TOUR:
                //判断是省内还是省外
                String key = TOUR_IN_REFUND;
                if(SYS_TRUE.equals(orderPageVO.getOrderTourDetail().getIsOutside())) {
                    key = TOUR_REFUND;
                }
                orderRefundAmount = orderRefundBiz.calculateRefund(orderPageVO.getGoodsAmount().subtract(orderPageVO.getCouponAmount())
                        , orderPageVO.getOrderTourDetail().getStartTime() - System.currentTimeMillis()
                        , DictionaryKey.APP_ORDER+ "_"+ DictionaryKey.RENT_REFUND
                        , refundDescBuilder);
                break;
            default:
                break;
        }

        OrderRefundPriceVO orpv = new OrderRefundPriceVO();
        orpv.setRealAmount(orderPageVO.getRealAmount());
        orpv.setRefundAmount(orderRefundAmount);
        orpv.setRefundDesc(refundDescBuilder.toString());
        return ObjectRestResponse.succ(orpv);
    }

    @Data
    public class OrderRefundPriceVO {
        BigDecimal refundAmount;
        BigDecimal realAmount;
        BigDecimal cutAmount;
        String refundDesc;

        public void setRefundAmount(BigDecimal refundAmount) {
            this.refundAmount = refundAmount;
            this.cutAmount = realAmount.subtract(refundAmount);
        }
    }
}