package com.xxfc.platform.order.biz.inner;

import cn.hutool.core.date.DateUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderMemberDetail;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.universal.dto.SmsTemplateDTO;
import com.xxfc.platform.universal.feign.ThirdFeign;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import com.xxfc.platform.vehicle.pojo.CompanyDetail;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;

/**
 * 订单退款记录表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-18 11:08:09
 */
@Slf4j
@Service
public class OrderMsgBiz {

    //客户通知
    public static final int RENT_PAY = 1;
    public static final int RENT_DELIVERY = 2;
    public static final int RENT_CANCEL = 3;


    @Autowired
    UserFeign userFeign;

    @Autowired
    ThirdFeign thirdFeign;

    @Autowired
    VehicleFeign vehicleFeign;

    /**
     * 处理App用户提醒短信的发送
     * @param orvd
     * @param omd
     * @param baseOrder
     * @param appUserDTO
     */
    public void handelAppUserMsg(OrderRentVehicleDetail orvd, OrderMemberDetail omd, BaseOrder baseOrder, AppUserDTO appUserDTO) {
        try {
            OrderTypeEnum orderTypeEnum = OrderTypeEnum.codeAndDesc.get(baseOrder.getType());
            Integer smstype;
            List<String> smsParams = new ArrayList<String>();
            smsParams.add(baseOrder.getRealAmount().toString());
            switch (orderTypeEnum) {
                case RENT_VEHICLE:
                    if(orvd.getFreeDays() > 0) {
                        smstype = SmsTemplateDTO.RENT_MEMENT;
                        smsParams.add(orvd.getFreeDays().toString());
                        smsParams.add(appUserDTO.getRentFreeDays().toString());
                    }else {
                        smstype = SmsTemplateDTO.RENT_NORMAL;
                    }
                    thirdFeign.sendTemplate(new SmsTemplateDTO(){{
                        setPhoneNumbers(appUserDTO.getUsername());
                        setType(smstype);
                        setParams(smsParams.toArray(new String[smsParams.size()]));
                    }});
                    break;
                case TOUR:
                    thirdFeign.sendTemplate(new SmsTemplateDTO(){{
                        setPhoneNumbers(appUserDTO.getUsername());
                        setType(SmsTemplateDTO.TOUR);
                        setParams(smsParams.toArray(new String[smsParams.size()]));
                    }});
                    break;
                case MEMBER:
                    smsParams.add(omd.getRentFreeNum().toString());
                    smsParams.add(appUserDTO.getRentFreeDays().toString());
                    thirdFeign.sendTemplate(new SmsTemplateDTO(){{
                        setPhoneNumbers(appUserDTO.getUsername());
                        setType(SmsTemplateDTO.MEMENT);
                        setParams(smsParams.toArray(new String[smsParams.size()]));
                    }});
                    break;
                default:
                    break;
            }
        }catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    /**
     * 处理后台用户提醒短信的发送
     * @param orvd
     * @param baseOrder
     * @param appUserDTO
     */
    public void handelBgUserMsg4Pay(OrderRentVehicleDetail orvd, BaseOrder baseOrder, AppUserDTO appUserDTO, Integer handelType) {
        try {
            OrderTypeEnum orderTypeEnum = OrderTypeEnum.codeAndDesc.get(baseOrder.getType());
            Integer smstype;
            List<String> smsParams = new ArrayList<String>();
            switch (orderTypeEnum) {
                case RENT_VEHICLE:
                    switch (handelType) {
                        case RENT_PAY:
                            //如果公司相同
                            if(null != orvd.getStartCompanyId() && !SYS_FALSE.equals(orvd.getStartCompanyId())) {
                                CompanyDetail companyDetail = vehicleFeign.getCompanyDetail(orvd.getStartCompanyId()).getData();
                                if(orvd.getStartCompanyId().equals(orvd.getEndCompanyId())) {
                                    smstype = SmsTemplateDTO.TAAKE_CAR;
                                }else {
                                    smstype = SmsTemplateDTO.DIFFERENT_TAAKE_CAR;
                                }
                                handelSmsParam(orvd, baseOrder, smsParams, appUserDTO, RENT_PAY);
                                SmsTemplateDTO smsTemplateDTO = new SmsTemplateDTO(){{
                                    setPhoneNumbers(companyDetail.getVehiceServicePhone());
                                    setType(smstype);
                                    setParams(smsParams.toArray(new String[smsParams.size()]));
                                }};
                                thirdFeign.sendTemplate(smsTemplateDTO);
                            }else {
                                log.error("通知后台客户短信异常，开始公司id 不存在或者为0 订单号：{}", baseOrder.getId());
                            }
                            break;
                        case RENT_DELIVERY:
                            //如果公司相同
                            if(null != orvd.getEndCompanyId() && !SYS_FALSE.equals(orvd.getEndCompanyId())) {
                                CompanyDetail companyDetail = vehicleFeign.getCompanyDetail(orvd.getEndCompanyId()).getData();
                                //不相同发送，相同不用发送
                                if(!orvd.getEndCompanyId().equals(orvd.getStartCompanyId())) {
                                    handelSmsParam(orvd, baseOrder, smsParams, appUserDTO, RENT_DELIVERY);
                                    thirdFeign.sendTemplate(new SmsTemplateDTO(){{
                                        setPhoneNumbers(companyDetail.getVehiceServicePhone());
                                        setType(SmsTemplateDTO.ALSO_CAR);
                                        setParams(smsParams.toArray(new String[smsParams.size()]));
                                    }});
                                }
                            }else {
                                log.error("通知后台客户短信异常，结束公司id 不存在或者为0 订单号：{}", baseOrder.getId());
                            }
                            break;
                        case RENT_CANCEL:
                            if(null != orvd.getEndCompanyId() && !SYS_FALSE.equals(orvd.getEndCompanyId())) {
                                handelSmsParam(orvd, baseOrder, smsParams, appUserDTO, RENT_CANCEL);
                                CompanyDetail companyDetail2 = vehicleFeign.getCompanyDetail(orvd.getEndCompanyId()).getData();
                                SmsTemplateDTO smsTemplateDTO = new SmsTemplateDTO();
                                smsTemplateDTO.setPhoneNumbers(companyDetail2.getVehiceServicePhone());
                                smsTemplateDTO.setType(Integer.valueOf(SmsTemplateDTO.CANCEL));
                                List<String> smsParams2 = smsParams;
                                smsTemplateDTO.setParams(smsParams2.toArray(new String[smsParams2.size()]));
                                thirdFeign.sendTemplate(smsTemplateDTO);
                            }else {
                                log.error("通知后台客户短信异常，结束公司id 不存在或者为0 订单号：{}", baseOrder.getId());
                            }
                            break;
                        default:
                            break;
                    }
                    break;
                default:
                    break;
            }
        }catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    private void handelSmsParam(OrderRentVehicleDetail orvd, BaseOrder baseOrder, List<String> smsParams, AppUserDTO appUserDTO, int handelType) {
        if(RENT_DELIVERY == handelType) {
            smsParams.add(appUserDTO.getRealname());
            smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getEndTime())));
            smsParams.add(orvd.getEndAddr());
            smsParams.add(baseOrder.getName());
            smsParams.add(appUserDTO.getUsername());
        }else {
            smsParams.add(appUserDTO.getRealname());
            smsParams.add(baseOrder.getName());
            smsParams.add(orvd.getStartAddr());
            smsParams.add(orvd.getEndAddr());
            smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getStartTime())));
            smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getEndTime())));
            smsParams.add(orvd.getDayNum().toString());
            smsParams.add(appUserDTO.getUsername());
        }
    }

}