package com.xxfc.platform.app.biz;

import com.ace.cache.annotation.Cache;
import com.ace.cache.annotation.CacheClear;
import com.alibaba.fastjson.JSON;
import com.github.wxiaoqi.security.common.msg.TableResultResponse;
import com.github.wxiaoqi.security.common.util.EntityUtils;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.app.entity.vo.WithDrawRuleVo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import com.xxfc.platform.app.entity.Cofig;
import com.xxfc.platform.app.mapper.CofigMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.List;
import java.util.Map;

/**
 * 系统配置表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-03 15:57:13
 */
@Service
public class CofigBiz extends BaseBiz<CofigMapper,Cofig> {

    public List<Cofig> getConfigByType(List<Integer> list){
        return  mapper.getAllByType(list);

    }

    /**
     * 修改配置
     * @param cofig
     * @return
     */
    @CacheClear(pre = "app:withdrawrule{1.type}")
    public int updateConfig(Cofig cofig) {
        EntityUtils.setUpdatedInfo(cofig);
       return mapper.updateByPrimaryKeySelective(cofig);
    }

    @Cache(key = "app:withdrawrule:88")
    public WithDrawRuleVo getWithDrawRule(){
        WithDrawRuleVo withDrawRuleVo = new WithDrawRuleVo();
        Example example  = new Example(Cofig.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("type",88);
        List<Cofig> cofigs = mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(cofigs)){
            return withDrawRuleVo;
        }
        Cofig cofig = cofigs.get(0);
       withDrawRuleVo = JSON.parseObject(cofig.getParams(),WithDrawRuleVo.class);
       withDrawRuleVo.setDescription(cofig.getValue());
       return withDrawRuleVo;
    }

    public void updateConfigStatus(int id) {
        Cofig cofig = new Cofig();
        cofig.setId(id);
        cofig.setIsDel(1);
        mapper.updateByPrimaryKeySelective(cofig);
    }

    public TableResultResponse<Cofig> listWithPage(Map<String, Object> params) {
        Query query = new Query(params);
        Example example = new Example(Cofig.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isDel",0);

        PageDataVO<Cofig> cofigPage = PageDataVO.pageInfo(query.getPage(), query.getLimit(), () -> mapper.selectByExample(example));

        return new TableResultResponse<>(cofigPage.getTotalCount(),cofigPage.getData()) ;
    }
}