package com.xxfc.platform.app.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

/**
 * @author libin
 * @version 1.0
 * @description banner 设置
 * @data 2019/6/26 9:20
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Banner {
    private static final long serialVersionUID = 1L;

    /**
     * 	首页banner图主键
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("首页banner图主键")
    private Long id;

    /**
     * 标题
     */
    @Column(name = "title")
    @ApiModelProperty(value = "标题")
    private String title;

    /**
     * 封面
     */
    @Column(name = "cover")
    @ApiModelProperty(value = "封面")
    private String cover;

    /**
     * 创建人
     */
    @Column(name = "crt_name")
    @ApiModelProperty(value = "创建人")
    private String crtName;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    @ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;

    /**
     * 更新人
     */
    @Column(name = "upd_name")
    @ApiModelProperty(value = "更新人")
    private String updName;

    /**
     * 修改时间
     */
    @Column(name = "upd_time")
    @ApiModelProperty(value = "修改时间", hidden = true )
    private Long updTime;

    /**
     * 跳转链接
     */
    @Column(name = "url")
    @ApiModelProperty(value = "跳转链接")
    private String url;

    /**
     * 是否删除，0否，1是
     */
    @Column(name = "is_del")
    @ApiModelProperty(value = "是否删除，0否，1是")
    private Integer isDel;

    /**
     * 排序
     */
    @Column(name = "rank")
    @ApiModelProperty(value = "排序")
    private Integer rank;

    /**
     *'类型:0-app首页,1-app旅游页；2-租车' 3-营地,
     */
    @Column(name = "type")
    @ApiModelProperty(value = "banner类型")
    private Integer  type;

    /**
     * 位置 banner位置0 所有 1：推荐 2：拍拍 3：短视频 4：问答
     */
    private Integer location;
}
