package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.activity.biz.ActivityListBiz;
import com.xxfc.platform.activity.biz.HomeActivitiesBiz;
import com.xxfc.platform.activity.entity.ActivityList;
import com.xxfc.platform.activity.entity.ActivityManagement;
import com.xxfc.platform.activity.entity.HomeActivities;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

@RestController
@RequestMapping("activityList")
public class ActivityListController extends BaseController<ActivityListBiz,ActivityList> {

    @Autowired
   private HomeActivitiesBiz homeActivitiesBiz;
    /**
     * 精彩活动列表
     * @return
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    @GetMapping("/app/unauth/activity/findAll")
    public ObjectRestResponse<List<HomeActivities>>  appFindAll() throws InvocationTargetException, IllegalAccessException {
        List<HomeActivities> activities = homeActivitiesBiz.activities();
//        List<ActivityList> list= baseBiz.activities();
        return ObjectRestResponse.succ(activities);
    }
}