package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.AppUserDetailBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserLoginBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserRelationBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserSellingWaterBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.feign.ActivityFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/24 15:11
 */
@RestController
@RequestMapping("/app/unauth/user_data")
public class DataController {

    @Autowired
    private AppUserLoginBiz appUserLoginBiz;

    @Autowired
    private AppUserDetailBiz appUserDetailBiz;

    @Autowired
    private AppUserRelationBiz appUserRelationBiz;

    @Autowired
    private AppUserSellingWaterBiz appUserSellingWaterBiz;

    @Autowired
    private ActivityFeign activityFeign;

    @GetMapping("/clearwithphone")
    public ObjectRestResponse<Void> clearData(@RequestParam("phones") List<String> phons) {

        Map<String, Integer> phoneAndUserIdMapByPhones = appUserLoginBiz.findPhoneAndUserIdMapByPhones(phons);
        if (Objects.nonNull(phoneAndUserIdMapByPhones)){
            Collection<Integer> userIds = phoneAndUserIdMapByPhones.values();
            appUserLoginBiz.deleteByPhones(phons);
            appUserDetailBiz.deleteByUserIds(userIds);
            appUserRelationBiz.deleteByMemberIds(userIds);
            appUserSellingWaterBiz.deleteByMemberIds(userIds);
            activityFeign.clearDate(new ArrayList<>(userIds));
        }
        return ObjectRestResponse.succ();
    }
}