package com.github.wxiaoqi.security.common.util;

import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import java.util.Map;

/**
 * 
 * @ClassName: IntervalUtil
 * @author: kangyl17909
 * @date: 2018年7月3日
 */
public class IntervalUtil {

    /**
     * 判断data_value是否在interval区间范围内
     * @author: kangyl17909
     * @date: 2018年7月3日
     * @param data_value 数值类型的
     * @param interval 正常的数学区间，包括无穷大等，如：(1,3)、>5%、(-∞,6]、(125%,135%)U(70%,80%)
     * @return true：表示data_value在区间interval范围内，false：表示data_value不在区间interval范围内
     */
    public boolean isInTheInterval(String data_value,String interval) {
        //将区间和data_value转化为可计算的表达式
        String formula = getFormulaByAllInterval(data_value,interval,"||");
        ScriptEngine jse = new ScriptEngineManager().getEngineByName("JavaScript"); 
        try {  
            //计算表达式
            return (Boolean) jse.eval(formula);
        } catch (Exception t) { 
            return false;
        }
    }

    /**
     * 将所有阀值区间转化为公式：如
     * [75,80)   =》        date_value < 80 && date_value >= 75 
     * (125%,135%)U(70%,80%)   =》        (date_value < 1.35 && date_value > 1.25) || (date_value < 0.8 && date_value > 0.7) 
     * @param date_value
     * @param interval  形式如：(125%,135%)U(70%,80%)
     * @param connector 连接符 如：") || ("
     */
    private String getFormulaByAllInterval(String date_value, String interval, String connector) {
        StringBuffer buff = new StringBuffer();
        for(String limit:interval.split("U")){//如：（125%,135%）U (70%,80%)
            buff.append("(").append(getFormulaByInterval(date_value, limit," && ")).append(")").append(connector);
        }
        String allLimitInvel = buff.toString();
        int index = allLimitInvel.lastIndexOf(connector);
        allLimitInvel = allLimitInvel.substring(0,index);
        return allLimitInvel;
    }

    /**
     * 将整个阀值区间转化为公式：如
     * 145)      =》         date_value < 145
     * [75,80)   =》        date_value < 80 && date_value >= 75 
     * @param date_value
     * @param interval  形式如：145)、[75,80)
     * @param connector 连接符 如：&&
     */
    private String getFormulaByInterval(String date_value, String interval, String connector) {
        StringBuffer buff = new StringBuffer();
        for(String halfInterval:interval.split(",")){//如：[75,80)、≥80
            buff.append(getFormulaByHalfInterval(halfInterval, date_value)).append(connector);
        }
        String limitInvel = buff.toString();
        int index = limitInvel.lastIndexOf(connector);
        limitInvel = limitInvel.substring(0,index);
        return limitInvel;
    }

    /**
     * 将半个阀值区间转化为公式：如
     * 145)      =》         date_value < 145
     * ≥80%      =》         date_value >= 0.8
     * [130      =》         date_value >= 130
     * <80%     =》         date_value < 0.8
     * @param halfInterval  形式如：145)、≥80%、[130、<80%
     * @param date_value
     * @return date_value < 145
     */
    private String getFormulaByHalfInterval(String halfInterval, String date_value) {
        halfInterval = halfInterval.trim(); 
        if(halfInterval.contains("∞")){//包含无穷大则不需要公式
            return "1 == 1";
        }
        StringBuffer formula = new StringBuffer();
        String data = "";
        String opera = "";
        if(halfInterval.matches("^([<>≤≥\\[\\(]{1}(-?\\d+.?\\d*\\%?))$")){//表示判断方向（如>）在前面 如：≥80%
            opera = halfInterval.substring(0,1);
            data = halfInterval.substring(1);
        }else{//[130、145)
            opera = halfInterval.substring(halfInterval.length()-1);
            data = halfInterval.substring(0,halfInterval.length()-1);
        }
        double value = dealPercent(data);
        formula.append(date_value).append(" ").append(opera).append(" ").append(value);
        String a = formula.toString();
        //转化特定字符
        return a.replace("[", ">=").replace("(", ">").replace("]", "<=").replace(")", "<").replace("≤", "<=").replace("≥", ">=");
    }

    /**
     * 去除百分号，转为小数
     * @param str 可能含百分号的数字
     * @return
     */
    private double dealPercent(String str){
        double d = 0.0;
        if(str.contains("%")){
            str = str.substring(0,str.length()-1);
            d = Double.parseDouble(str)/100;
        }else{
            d = Double.parseDouble(str);
        }
        return d;
    }

    public static boolean staticIsInTheInterval(String data_value,String interval) {
        return new IntervalUtil().isInTheInterval(data_value, interval);
    }

    public static Object evaluate(String expression, JexlContext jexlContext) {
        Expression e = new JexlEngine().createExpression(expression);
        return e.evaluate(jexlContext);
    }

    public static Object evaluate(String expression, Map<String, Object> jexlContextMap) {
        Expression e = new JexlEngine().createExpression(expression);
        JexlContext jexlContext = new MapContext();
        jexlContextMap.forEach((k, v) -> jexlContext.set(k, v));
        return e.evaluate(jexlContext);
    }

    public static void main(String[] args) {
        IntervalUtil a = new IntervalUtil();
        System.out.println(a.isInTheInterval("6", "(-∞,6]"));
    }
}
