package com.xxfc.platform.vehicle.biz;



import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.app.entity.Cofig;
import com.xxfc.platform.app.feign.ConfigFeign;
import com.xxfc.platform.vehicle.entity.VehiclePublish;
import com.xxfc.platform.vehicle.entity.VehiclePublishGoods;
import com.xxfc.platform.vehicle.mapper.VehiclePublishMapper;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePublishFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehiclePublishVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


@Service
@Slf4j
public class VehiclePublishBiz extends BaseBiz<VehiclePublishMapper, VehiclePublish> {



    @Autowired
    VehiclePublishGoodsBiz publishGoodsBiz;

    @Autowired
    ConfigFeign configFeign;



    @Transactional(rollbackFor = Exception.class)
    public  void  addOrUpd(VehiclePublish vehiclePublish){
        List<VehiclePublishGoods> goodsList = vehiclePublish.getPublishGoodsList();
        if (CollectionUtils.isEmpty(goodsList)){
            throw  new BaseException("参数不能为空", ResultCode.FAILED_CODE);
        }
        vehiclePublish.setId(null);
        insertSelective(vehiclePublish);
        Integer id = vehiclePublish.getId();
        JSONObject config = getConfig();
        for (VehiclePublishGoods publishGoods : goodsList){
            publishGoods.setId(null);
            publishGoods.setPublishId(id);
            publishGoods.setGoodsType(vehiclePublish.getGoodsType());
            publishGoods.setPublishAmount(config.getBigDecimal("publishAmount"));
            publishGoods.setReceiveAmount(config.getBigDecimal("receiveAmount"));
            publishGoodsBiz.insertSelective(publishGoods);
        }

    }




    public List<VehiclePublishVo> getList(VehiclePublishFindDTO publishFindDTO){
        return  mapper.selectList(publishFindDTO);
    }

    public PageDataVO<VehiclePublishVo> selectList(VehiclePublishFindDTO publishFindDTO){
        Integer page = publishFindDTO.getPage() == null ? 1 : publishFindDTO.getPage();
        Integer limit = publishFindDTO.getLimit() == null ? 10 : publishFindDTO.getLimit();
        PageHelper.startPage(page, limit);
        PageInfo<VehiclePublishVo> pageInfo = new PageInfo<>(getList(publishFindDTO));
        PageDataVO<VehiclePublishVo> pageDataVO = PageDataVO.pageInfo(pageInfo);
        List<VehiclePublishVo> list = pageDataVO.getData();
        if (CollectionUtils.isNotEmpty(list)){
            for (VehiclePublishVo publishVo : list){
                publishFindDTO.setPublishId(publishVo.getId());
                publishVo.setPublishGoodsVos(publishGoodsBiz.getList(publishFindDTO));
            }
        }
        return pageDataVO;
    }


    public  VehiclePublishVo  detail(VehiclePublishFindDTO publishFindDTO){
        PageDataVO<VehiclePublishVo> pageDataVO = selectList(publishFindDTO);
        List<VehiclePublishVo> list = pageDataVO.getData();
        VehiclePublishVo  publishVo = new VehiclePublishVo();
        if (CollectionUtils.isNotEmpty(list)){
            publishVo=list.get(0);
        }
        return  publishVo;
    }



    //入驻规则管理
    public JSONObject getConfig(){
        try {
            List<Cofig> list=configFeign.getAllByType(ConfigFeign.TYPE_VEHICLE_PUBLISH+"").getData();
            if (list!=null && list.size()>0){
                String params=list.get(0).getParams();
                JSONObject object = JSONObject.parseObject(params);
                return  object;
            }
        }catch (Exception e){
            log.error(e.getMessage(), e);;
        }
        return  null;
    }


    public  void  updWaitConfirmNumber(Integer number,Integer id){
        mapper.updWaitConfirmNumber(number,id);
    }


    public  void  updConfirmNumber(Integer number,Integer id){
        mapper.updConfirmNumber(number,id);
    }









}
