package com.xxfc.platform.summit.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.summit.biz.ActivityBiz;
import com.xxfc.platform.summit.biz.ActivityShowBiz;
import com.xxfc.platform.summit.dto.ActivityShowDto;
import com.xxfc.platform.summit.entity.Activity;
import com.xxfc.platform.summit.entity.ActivityShow;
import org.springframework.web.bind.annotation.*;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("/activityShow")
public class ActivityShowController extends BaseController<ActivityShowBiz, ActivityShow> {
    @GetMapping("/one/{activityId}")
    public ObjectRestResponse getOne(@PathVariable Integer activityId){

      return ObjectRestResponse.succ( baseBiz.getOne(activityId));
    }


    @PostMapping("/save")
    public ObjectRestResponse save(@RequestBody ActivityShowDto showDto){
         if (baseBiz.save(showDto)){
             return ObjectRestResponse.succ();
         }
         return ObjectRestResponse.createDefaultFail();
    }
}
