package com.xxfc.platform.activity.vo;

import com.xxfc.platform.activity.entity.Coupon;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;
import java.util.List;


/**
 * 通用活动规则表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-16 14:04:22
 */
@Data
public class ActivityRuleVo implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键id
   */
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  活动名称
     */
	@ApiModelProperty(value = "活动名称")
    private String name;

	/**
	 *  活动名称
	 */
	@ApiModelProperty(value = "活动名称")
	private String img;


	/**
     *  活动描述
     */
	@ApiModelProperty(value = "活动描述")
    private String descr;
	
	    /**
     *  活动人数限制
     */
	@ApiModelProperty(value = "活动人数限制")
    private Integer number;
	
	    /**
     *  参加活动人数
     */
	@ApiModelProperty(value = "参加活动人数")
    private Integer joinNumber;
	
	    /**
     *  活动是否开启：0-未开启；1-已开启;2-已关闭
     */
	@ApiModelProperty(value = "活动是否开启：0-未开启；1-已开启;2-已关闭")
    private Integer status;
	
	    /**
     *  活动奖励规则,json数组格式 [{"type":1, "detail":{...}},...] //// type分类 1--现金；
     */
	@ApiModelProperty(value = "活动奖励规则,json数组格式 [{type:1, detail:{...}},...] //// type分类 1--现金；")
    private String value;
	
	    /**
     *  创建时间
     */
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  是否删除：0-正常；1-删除
     */
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;

	@ApiModelProperty(value = "优惠卷列表")
	List<Coupon> coupons;
	

}
