package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.vehicle.biz.VehicleApplyBiz;
import com.xxfc.platform.vehicle.biz.VehicleBiz;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.pojo.dto.VehicleFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/vehicle")
@Api(tags = {"商家入驻"})
public class AppVehicleController extends BaseController<VehicleBiz> {





    @GetMapping("selectList")
    @ApiModelProperty("商品列表")
    public  ObjectRestResponse selectList(VehicleFindDTO vehicleFindDTO) {
        if (vehicleFindDTO.getBranchId() == null || vehicleFindDTO.getBranchId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                vehicleFindDTO.setBranchId(companyIds.get(0));
            }
        }
        return  baseBiz.selectList(vehicleFindDTO);
    }


    @PostMapping("updVehicle")
    @ApiModelProperty("更新商品信息")
    public  ObjectRestResponse updVehicle(@RequestBody Vehicle vehicle) {
        return baseBiz.updState(vehicle);
    }


    @GetMapping("info")
    @ApiModelProperty("商品详情")
    public  ObjectRestResponse info(VehicleFindDTO vehicleFindDTO) {
        return  ObjectRestResponse.succ(baseBiz.info(vehicleFindDTO));
    }


    @GetMapping("app/unauth/detail/{id}")
    @ApiModelProperty("商品详情")
    @IgnoreUserToken
    public  ObjectRestResponse detail(@PathVariable("id") String id ) {
        VehicleFindDTO vehicleFindDTO =new VehicleFindDTO();
        vehicleFindDTO.setVehicleId(id);
        List<VehicleVO> list = baseBiz.getList(vehicleFindDTO);
        if (list.size() == 0){
            return  ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"商品不存在");
        }
        return  ObjectRestResponse.succ(list.get(0));
    }


    @GetMapping("app/unauth/countByCompamyId")
    @ApiModelProperty("商品数量")
    @IgnoreUserToken
    public  ObjectRestResponse countByCompamyId(@RequestParam(value = "id",defaultValue = "0") Integer id ) {
        if (id == null || id == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                id=companyIds.get(0);
            }
        }
        return  ObjectRestResponse.succ(baseBiz.countByCompanyId(id));
    }














}
