package com.xxfc.platform.vehicle.pojo.vo;

import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelCalendarPriceDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class UsableVeicleVO extends Vehicle {

    @Column(name = "to_lift_company_id")
    private Integer toLiftCompanyId;
    @Column(name = "to_lift_must_after_date")
    private Date toLiftMustAfterDate;
    @Column(name = "to_return_company_id")
    private Integer toReturnCompanyId;
    @Column(name = "to_return_must_before_date")
    private Date toReturnMustBeforeDate;

    private Integer allowRent;

    private List<VehicleModelCalendarPriceDTO> priceDTOS;

    @ApiModelProperty(value = "公里数")
    BigDecimal distance;

}
