package com.xxfc.platform.app.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

/**
 * @author libin
 * @version 1.0
 * @description banner 设置
 * @data 2019/6/26 9:20
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Banner {
    private static final long serialVersionUID = 1L;

    /**
     * 	首页banner图主键
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("首页banner图主键")
    private Long id;

    /**
     * 标题
     */
    @Column(name = "title")
    @ApiModelProperty(value = "标题")
    private String title;

    /**
     * 封面
     */
    @Column(name = "cover")
    @ApiModelProperty(value = "封面")
    private String cover;

    /**
     * 创建人
     */
    @Column(name = "crt_name")
    @ApiModelProperty(value = "创建人")
    private String crtName;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    @ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;

    /**
     * 更新人
     */
    @Column(name = "upd_name")
    @ApiModelProperty(value = "更新人")
    private String updName;

    /**
     * 修改时间
     */
    @Column(name = "upd_time")
    @ApiModelProperty(value = "修改时间", hidden = true )
    private Long updTime;

    /**
     * 跳转链接
     */
    @Column(name = "url")
    @ApiModelProperty(value = "跳转链接")
    private String url;

    @Column(name = "ios_url")
    @ApiModelProperty(value = "ios跳转地址")
    private String iosUrl;

    @Column(name = "applet_url")
    @ApiModelProperty("小程序跳转地址")
    private String appletUrl;

    /**
     * 是否删除，0否，1是
     */
    @Column(name = "is_del")
    @ApiModelProperty(value = "是否删除，0否，1是")
    private Integer isDel;

    /**
     * 排序
     */
    @Column(name = "rank")
    @ApiModelProperty(value = "排序")
    private Integer rank;

    /**
     *'类型:0-app首页,1-app旅游页；2-租车' 3-营地,
     */
    @Column(name = "type")
    @ApiModelProperty(value = "banner类型")
    private Integer  type;

    /**
     * 位置 banner位置0：所有 1：首页 2：房车主页 3：机车主页 4：游艇主页
     */
    private Integer location;

    /**
     * 平台 0：APP 1：欣欣房车官网 2：滴房车官网
     */
    private Integer platform;

    /**
     * html 标签悬浮显示  seo 需要
     */
    private String alt;

    /**
     * 跳转类型 0--不跳转；1--商品详情页；2--店铺主页；
     */
    @Column(name = "jump_type")
    private Integer jumpType;

    /**
     * 跳转 商品/店铺 id；
     */
    @Column(name = "jump_id")
    private String jumpId;

    /**
     * 状态 1--上架；2--下架
     */
    @Column(name = "status")
    private Integer status;
}
