package com.xxfc.platform.activity.biz;

import cn.hutool.core.date.DateUtil;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.excel.ExcelUtils;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.dto.ActivityLuckDrawFindDTO;
import com.xxfc.platform.activity.entity.ActivityLuckyDraw;
import com.xxfc.platform.activity.mapper.ActivityLuckyDrawMapper;
import com.xxfc.platform.activity.vo.ActivityLuckyDrawListVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.ServletOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 活动抽奖报名表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-12-03 16:46:02
 */
@Transactional(rollbackFor = Exception.class)
@Service
public class ActivityLuckyDrawBiz extends BaseBiz<ActivityLuckyDrawMapper, ActivityLuckyDraw> {

    /**
     * 报名
     *
     * @param activityLuckyDraw
     */
    public void signUp(ActivityLuckyDraw activityLuckyDraw) {
        activityLuckyDraw.setCrtTime(new Date());
        mapper.insertSelective(activityLuckyDraw);
    }

    /**
     * 分页查询报名列表
     *
     * @param activityLuckDrawFindDTO
     * @return
            */
    public PageDataVO<ActivityLuckyDraw> listLuckDrawWithPage(ActivityLuckDrawFindDTO activityLuckDrawFindDTO) {
        PageDataVO<ActivityLuckyDraw> dataVO = PageDataVO.pageInfo(activityLuckDrawFindDTO.getPage(), activityLuckDrawFindDTO.getLimit(), () -> mapper.listLuckDrawWithPage(activityLuckDrawFindDTO));
        List<ActivityLuckyDraw> data = dataVO.getData();
        if (CollectionUtils.isEmpty(data)) {
            PageDataVO<ActivityLuckyDraw> activityLuckyDrawPageDataVO = new PageDataVO<>();
            activityLuckyDrawPageDataVO.setPageNum(activityLuckDrawFindDTO.getPage());
            activityLuckyDrawPageDataVO.setPageSize(activityLuckDrawFindDTO.getLimit());
            return activityLuckyDrawPageDataVO;
        }
        return dataVO;
    }

    public void exportActivityLuckDrawData(ActivityLuckDrawFindDTO activityLuckDrawFindDTO, ServletOutputStream outputStream) throws IOException {
        List<ActivityLuckyDrawListVo> activityLuckyDraws = listActivityLuckDraw(activityLuckDrawFindDTO);
        ExcelUtils excelUtils = new ExcelUtils("报名列表");
        XSSFWorkbook hssfWorkbook = excelUtils.getHssfWorkbook();
        XSSFSheet sheet = excelUtils.getSheet();

        Row headerRow = sheet.createRow(0);
        CellStyle headerCellStyle = excelUtils.createHeaderCellStyle();
        String[] headers = {"姓名","电话","身份","上级姓名","上级电话","人数","报名时间"};
        excelUtils.createHeader(headerRow,0,headers,headerCellStyle);

        CellStyle generalCellStyle = excelUtils.createGeneralCellStyle();
        List<String[]> activityLuckDrawDataList = getActivityLuckDrawDataList(activityLuckyDraws);
        excelUtils.createCellData(sheet,1,generalCellStyle,activityLuckDrawDataList);

        hssfWorkbook.write(outputStream);
        hssfWorkbook.close();


    }

    private List<String[]> getActivityLuckDrawDataList(List<ActivityLuckyDrawListVo> activityLuckyDraws){
         List<String[]> activityLuckDrawDataList = new ArrayList<>(activityLuckyDraws.size());
        for (ActivityLuckyDrawListVo activityLuckyDraw : activityLuckyDraws) {
            String[] activityLuckDrawData = getActivityLuckDrawData(activityLuckyDraw);
            activityLuckDrawDataList.add(activityLuckDrawData);
        }
        return activityLuckDrawDataList;
    }

    private String[] getActivityLuckDrawData(ActivityLuckyDrawListVo activityLuckyDraw){
        Date crtTime = activityLuckyDraw.getCrtTime();
        String timeStr = DateUtil.format(crtTime, "yyyy-MM-dd HH:mm:ss");
        return new String[]{activityLuckyDraw.getUserName(),activityLuckyDraw.getPhone(),activityLuckyDraw.getPositionName(),activityLuckyDraw.getParentName(),activityLuckyDraw.getParentPhone(),activityLuckyDraw.getTicketNum()+"",timeStr};
    }

    public List<ActivityLuckyDrawListVo> listActivityLuckDraw(ActivityLuckDrawFindDTO activityLuckDrawFindDTO){
        Query query = new Query(activityLuckDrawFindDTO);
        List<ActivityLuckyDrawListVo> activityLuckyDraws = mapper.getAllByPage(query.getSuper());
        if (CollectionUtils.isEmpty(activityLuckyDraws)){
            return Collections.EMPTY_LIST;
        }
        return activityLuckyDraws;
    }

    public ObjectRestResponse<PageDataVO<ActivityLuckyDrawListVo>> getAll(ActivityLuckDrawFindDTO activityLuckDrawFindDTO) {
        Integer page = activityLuckDrawFindDTO.getPage() == null ? 1 : activityLuckDrawFindDTO.getPage();
        Integer limit = activityLuckDrawFindDTO.getLimit() == null ? 10 : activityLuckDrawFindDTO.getLimit();
        activityLuckDrawFindDTO.setPage(page);
        activityLuckDrawFindDTO.setLimit(limit);
        Query query = new Query(activityLuckDrawFindDTO);
        PageDataVO<ActivityLuckyDrawListVo> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.getAllByPage(query.getSuper()));
        return ObjectRestResponse.succ(pageDataVO);
        //添加个人积分状态
    }
}