package com.github.wxiaoqi.security.admin.rest;


import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.admin.biz.UserBiz;
import com.github.wxiaoqi.security.admin.entity.User;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Slf4j
public class BaseController<Biz extends BaseBiz> extends CommonBaseController{
    
    @Autowired
    protected Biz baseBiz;

    @Autowired
    protected UserAuthConfig userAuthConfig;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserBiz userBiz;


    public String getUserName()throws Exception{ return  userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getUniqueName(); }

    public Biz getBaseBiz() {
        return baseBiz;
    }

    public String getUserId()throws Exception{ return  userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId(); }

    public List<Integer> getBusinessUserCompanyIds(){
        String currentUserName = getCurrentUserName();
        if (StrUtil.isNotBlank(currentUserName)){
            ObjectRestResponse<User> restResponse = userBiz.userinfoByMobilePhone(currentUserName);
            if (restResponse.getData() != null){
                User userDTO =restResponse.getData();
                if (userDTO != null){
                    return  userDTO.getCompanyIds();
                }
            }
        }
        return  null;
    }

}
