package com.github.wxiaoqi.security.admin.mapper;

import com.github.wxiaoqi.security.admin.bo.UserIncomeBo;
import com.github.wxiaoqi.security.admin.bo.UserStaffBo;
import com.github.wxiaoqi.security.admin.dto.AppUserSellingWaterDTO;
import com.github.wxiaoqi.security.admin.dto.UserSellingWaterAdminDTO;
import com.github.wxiaoqi.security.admin.dto.UserSellingWaterFindDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserSellingWater;
import com.github.wxiaoqi.security.admin.vo.SellingWalletVo;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

import java.math.BigDecimal;
import java.util.List;

/**
 * 拥金明细表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
public interface AppUserSellingWaterMapper extends Mapper<AppUserSellingWater> {

    List<UserIncomeBo> accquireIncomeByMemberIds(@Param("parentId") Integer parentId);

    BigDecimal selectTotalIncomeByUserId(@Param("userId") Integer userId);

    List<SellingWalletVo> selectSellerWalterByUserIdAndWating(@Param("userId") Integer userId, @Param("wating") Integer wating);

    List<UserSellingWaterAdminDTO> selectSellingWaterPage(UserSellingWaterFindDTO userSellingWaterFindDTO);

    List<AppUserSellingWaterDTO> statisticsStatffSellerWaterByUserIdsAndTime(@Param("userIds") List<Integer> userIds,
                                                                             @Param("startTime") Long startTime,
                                                                             @Param("endTime") Long endTime);
    List<AppUserSellingWater> getCommisionByOrder(@Param("orderId") Integer orderId);
}
