package com.github.wxiaoqi.security.admin.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;

@Data
@Table(name = "company_info_apply")
public class CompanyInfoApply {

    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键id")
    private Long id;


    @ApiModelProperty("app用户id")
    @Column(name = "app_user_id")
    private Integer appUserId;


    @ApiModelProperty("商家id")
    @Column(name = "branch_id")
    private Long branchId;


        @ApiModelProperty("公司名称")
    private String name;


    @ApiModelProperty("公司类型：1-个体；2-企业")
    private Integer type;



    @ApiModelProperty("法人姓名")
    @Column(name = "legal_person")
    private String legalPerson;



    @ApiModelProperty("联系人")
    private String contact;



    @ApiModelProperty("联系电话")
    private String mobile;



    @ApiModelProperty("邀请人id")
    @Column(name = "inviter_account")
    private Integer inviterAccount;


    @ApiModelProperty("状态：0-待审核；1-审核成功；2-驳回")
    private Integer status;


    @ApiModelProperty("驳回原因")
    private String reason;


    @ApiModelProperty("支付金额")
    @Column(name = "pay_amount")
    private BigDecimal payAmount;



    @ApiModelProperty("商家审核信息json")
    @Column(name = "detail_json")
    private String detailJson;

    @ApiModelProperty("表单提交类型：1-申请入驻：2-修改信息")
    @Column(name = "form_type")
    private Integer formType;


    @Column(name = "crt_time")
    private Long crtTime;


    @Column(name = "upd_time")
    private Long updTime;


    @Column(name = "is_del")
    private Integer isDel;

}