package com.xxfc.platform.im.entity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Table;

/**
 * @author libin
 * @version 1.0
 * @description 客服
 * @data 2019/9/5 9:27
 */
@Data
@Builder(toBuilder = true)
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "customer_service")
@Document(collection = "customer_service")
public class CustomerService {
    private static final long serialVersionUID = 1L;
    @Id
    @javax.persistence.Id
    @GeneratedValue(generator = "JDBC")
    private Long id;
    /**
     * 客服名称
     */
    private String name;
    /**
     * 客服头像
     */
    private String icon;
    /**
     * App id
     */
    @Field("app_user_id")
    @Column(name = "app_user_id")
    private Integer appUserId;
    /**
     * im id
     */
    @Field("im_user_id")
    @Column(name = "im_user_id")
    private Integer imUserId;
    /**
     * 区域id
     */
    @Field("area_id")
    @Column(name = "area_id")
    private Integer areaId;
    /**
     * 区域名称
     */
    @Field("area_name")
    @Column(name = "area_name")
    private String areaName;
    /**
     * 问候语句
     */
    private String greeting;
    /**
     * 客服类型
     */
    private Integer type;
    /**
     * 客服电话
     */
    private String telphone;
    /**
     * 登录密码
     */
    private String password;
    /**
     * 是事删除 true：删除状态 1：正常
     */
    @Field("is_del")
    @Column(name = "is_del")
    private Boolean isDel;

    @Field("create_time")
    @Column(name = "create_time")
    private Long createTime;

    @Field("update_time")
    @Column(name = "update_time")
    private Long updateTime;

}
