package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleProfileDisplayBiz;
import com.xxfc.platform.vehicle.pojo.vo.LargeScreenDisplayBaseDataVo;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/26 9:41
 */
@RestController
@RequestMapping("/large_screen/app/unauth")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class LargeScreenDisplayCCTVehicleController {
    private final VehicleProfileDisplayBiz vehicleProfileDisplayBiz;
    /**
     * 车辆概况
     *
     * @return
     */
    @GetMapping("/base_cct_vehicle_profile_display")
    public ObjectRestResponse<LargeScreenDisplayBaseDataVo> findLargeScreenDisplayData() {
        LargeScreenDisplayBaseDataVo largeScreenDisplayBaseDataVo = vehicleProfileDisplayBiz.findVehicleProfileDisplayData();
        return ObjectRestResponse.succ(largeScreenDisplayBaseDataVo);
    }

}
