package com.xxfc.platform.vehicle.rest;


import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleManageApplyBiz;
import com.xxfc.platform.vehicle.entity.VehicleManageApply;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/vehicleManageApply")
@Api(tags = {"经营申请"})
public class AppVehicleManageApplyController extends BaseController<VehicleManageApplyBiz> {




    @PostMapping("save")
    @ApiModelProperty("申请")
    public  ObjectRestResponse save(@RequestBody VehicleManageApply vehicleManageApply) {
        if (vehicleManageApply.getApplyId() == null || vehicleManageApply.getApplyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                vehicleManageApply.setApplyId(companyIds.get(0));
            }
        }
        baseBiz.applyManage(vehicleManageApply);
        return ObjectRestResponse.succ();
    }


    @PostMapping("verify")
    @ApiModelProperty("申请")
    public  ObjectRestResponse verify(@RequestBody VehicleManageApply vehicleManageApply) {
        if (vehicleManageApply.getToApplyId() == null || vehicleManageApply.getToApplyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                Integer companyId = companyIds.get(0);
                vehicleManageApply.setToApplyId(companyId);
                vehicleManageApply.setVerifyId(companyId);
            }
        }
        baseBiz.setVerify(vehicleManageApply);
        return ObjectRestResponse.succ();
    }














}
