package com.xxfc.platform.order.pojo.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description 订单支付视图
 * @data 2019/12/24 17:39
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OrderPayProfileDispalyVo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 微信支付金额
     */
    private BigDecimal wxPayAmount = BigDecimal.ZERO;
    /**
     * 支付宝支付金额
     */
    private BigDecimal aliPayAmount = BigDecimal.ZERO;
    /**
     * app支付金额
     */
    private BigDecimal androidPayAmount = BigDecimal.ZERO;
    /**
     * ios支付金额
     */
    private BigDecimal iosPayAmount = BigDecimal.ZERO;
    /**
     * 微信占比
     */
    private String wxPayRatio;
    /**
     * 支付宝占比
     */
    private String aliPayRatio;
    /**
     * 安卓支付占比
     */
    private String androidPayRatio;
    /**
     * ios支付占比
     */
    private String iosPayRatio;
}
