package com.xxfc.platform.activity.biz;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.dto.ActivityDTO;
import com.xxfc.platform.activity.vo.ActivityVo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.xxfc.platform.activity.entity.Activity;
import com.xxfc.platform.activity.mapper.ActivityMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 峰会活动表
 *
 * @author wuweizhi
 * @email 18178966185@163.com
 * @date 2020-10-08 09:48:35
 */
@Service
public class ActivityBiz extends BaseBiz<ActivityMapper, Activity> {



    @Autowired
    private UserFeign userFeign;




    public ObjectRestResponse<PageDataVO<ActivityVo>> getAllByPage(ActivityDTO activityDTO) {
        Integer page = activityDTO.getPage() == null ? 1 : activityDTO.getPage();
        Integer limit = activityDTO.getLimit() == null ? 10 : activityDTO.getLimit();
        PageDataVO<ActivityVo> pageDataVO = PageDataVO.pageInfo(page,limit,()->getList(activityDTO) );
        List<ActivityVo>  list = pageDataVO.getData();
        setUserInfo(list);
        return ObjectRestResponse.succ(pageDataVO);
    }


    public  List<ActivityVo> getList(ActivityDTO activityDTO){
        return  mapper.getAllByPage(activityDTO);
    }



    public  void  setUserInfo(List<ActivityVo> list){
        if (CollectionUtils.isNotEmpty(list)){
            List<Integer> userIds = list.stream().map(ActivityVo::getUserId).distinct().collect(Collectors.toList());
            List<AppUserVo> appUserVos = userFeign.getByUserIds(userIds).getData();
            Map<Integer, AppUserVo> userMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(appUserVos)){
                for (AppUserVo appUserVo:appUserVos){
                    userMap.put(appUserVo.getId(),appUserVo);
                }
            }
            for(ActivityVo activityVo : list){
                AppUserVo appUserVo = userMap.get(activityVo.getUserId());
                if (appUserVo != null){
                    activityVo.setHeadimgurl(appUserVo.getHeadimgurl());
                    activityVo.setNickname(appUserVo.getNickname());
                    activityVo.setRealname(appUserVo.getRealname());
                    activityVo.setUsername(appUserVo.getUsername());
                }
            }
        }
    }

    public ActivityVo  getActivityInfo(ActivityDTO activityDTO){
        List<ActivityVo> list = getList(activityDTO);
        if (list.size() > 0){
            setUserInfo(list);
            return  list.get(0);
        }
        return  null;
    }
}


