package com.github.wxiaoqi.security.admin.biz;


import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.dto.CompanySearchDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserRelation;
import com.github.wxiaoqi.security.admin.entity.BranchCompany;
import com.github.wxiaoqi.security.admin.mapper.BranchCompanyMapper;
import com.github.wxiaoqi.security.admin.vo.CompanySearchVO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.universal.dto.SendMsgDTO;
import com.xxfc.platform.universal.feign.MQSenderFeign;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

import static com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant.*;


@Service
@Slf4j
public class BranchCompanyBiz extends BaseBiz<BranchCompanyMapper, BranchCompany>{


    @Autowired
    MQSenderFeign mqSenderFeign;


    public ObjectRestResponse addOrUpd(BranchCompany branchCompany){
        Long id = branchCompany.getId() == null ? 0L :branchCompany.getId();
        BranchCompany branchCompany1=selectById(id);
        branchCompany.setPhone(branchCompany.getLeaderContactInfo());
        branchCompany.setTourServicePhone(branchCompany.getLeaderContactInfo());
        branchCompany.setVehiceServicePhone(branchCompany.getLeaderContactInfo());
        if (branchCompany1 != null){
             updateSelectiveById(branchCompany);
        }else {
             insertSelective(branchCompany);
        }
        sendQueue(branchCompany);
        return  ObjectRestResponse.succ();
    }

    public Integer getCompanyByCode(String code) {
        Example example = new Example(BranchCompany.class);
        example.createCriteria().andEqualTo("code", code).andEqualTo("isDel", 0);
        List<BranchCompany> list = mapper.selectByExample(example);
        if (list != null && list.size() != 0) {
            return list.get(0).getId();
        }
        return 0;
    }



    public void sendQueue(BranchCompany branchCompany) {
        try {

            SendMsgDTO sendMsgDTO = new SendMsgDTO() {{
                setExchange(ADMIN_TOPIC);
            }};
            sendMsgDTO.setJson(JSONUtil.toJsonStr(branchCompany));
            sendMsgDTO.setRoutKey(KEY_COMPANY_UPD);
            mqSenderFeign.postSendMessage(sendMsgDTO);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }


    public PageDataVO<CompanySearchVO> search(CompanySearchDTO vo) {
        PageHelper.startPage(vo.getPage(), vo.getLimit());
        PageInfo<CompanySearchVO> branchCompanyPageInfo = new PageInfo<>(getList(vo));
        return PageDataVO.pageInfo(branchCompanyPageInfo);
    }


    public List<CompanySearchVO> getList(CompanySearchDTO vo){
        return  mapper.search(vo);
    }


    public ObjectRestResponse getHotCompany(Integer page,Integer limit){
        Example example = new Example(BranchCompany.class);
        example.createCriteria().andEqualTo("state",1).andEqualTo("isDel",0);
        example.orderBy("browseNum").asc();
        PageDataVO<BranchCompany> pageDataVO = PageDataVO.pageInfo(page, limit, () -> mapper.selectByExample(example));
        return ObjectRestResponse.succ(pageDataVO);
    }


}
