package com.github.wxiaoqi.security.admin.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 拥金明细
 */
@Data
public class OrderGoodsDTO {

    public static final Integer TYPE_RENT = 1;
    public static final Integer TYPE_TOUR = 2;
    public static final Integer TYPE_MEMBER = 3;
    public static final Integer TYPE_CAMPSITE = 4;

    /**
     *  商品id
     */
    @ApiModelProperty(value = "商品id")
    private String goodId;

    /**
     *  商品类型;1-租车；2-旅游；3-会员订单;4-营地
     */
    @ApiModelProperty(value = "商品类型")
    private Integer type;

    /**
     *  商品数量
     */
    @ApiModelProperty(value = "商品数量")
    private Integer goodNumber;

    /**
     *  商品标题
     */
    @ApiModelProperty(value = "商品标题")
    private String title;

    /**
     *  图片
     */
    @ApiModelProperty(value = "图片")
    private String img;


    /**
     *  售价
     */
    @ApiModelProperty(value = "售价")
    private BigDecimal price;

}