package com.xxfc.platform.universal.constant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 跳转页面类型
 */
public enum PushJumpType {
    ALL(0,"app首页"),
    VEHICLE_ORDER_DETAIL(1,"租车订单详情页"),
    TOUR_ORDER_DETAIL(2,"旅游订单详情页"),
    VEHICLE_ORDER_SCORE(3,"租车订单评价页"),
    TOUR_ORDER_SCORE(4,"旅游订单评价页面"),
    MEMBER_ORDER_DETAIL(5,"会员订单详情页"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();

    private static List<Map<String,Object>> list = new ArrayList<>();

    static{
        for(PushJumpType pushJumpType : PushJumpType.values()){
            codeAndDesc.put(pushJumpType.getCode(),pushJumpType.getDesc());
            Map<String,Object> map=new HashMap<>();
            map.put("code",pushJumpType.getCode());
            map.put("value",pushJumpType.getDesc());
            list.add(map);
        }
    }

    PushJumpType(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getByCode(Integer code) {
        switch (code) {
            case  1:
                return ALL.getDesc();
            case  2:
                return VEHICLE_ORDER_DETAIL.getDesc();
            case 3:
                return VEHICLE_ORDER_SCORE.getDesc();
            case 4:
                return TOUR_ORDER_SCORE.getDesc();
            case 5:
                return MEMBER_ORDER_DETAIL.getDesc();
        }
        return "";
    }
    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
    public static List<Map<String,Object>> getList(){
        return list;
    }


}
