package com.xxfc.platform.uccn.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.util.Date;

@Data
@Table(name = "seo")
@ApiModel(value = "seo列表实体")
@NoArgsConstructor
public class SEO {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "主键")
    private Integer id;


    @Column(name = "model_id")
    @ApiModelProperty(value = "模块id")
    private Integer modelId;

    @Column(name = "title")
    @ApiModelProperty(value = "title内容")
    private String title;

    @Column(name = "keywords")
    @ApiModelProperty(value = "关键子")
    private String keywords;

    @Column(name = "description")
    @ApiModelProperty(value = "description内容")
    private String description;

    @Column(name = "header")
    @ApiModelProperty(value = "标题")
    private String header;


    @Column(name = "cre_time")
    @ApiModelProperty(value = " 创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date creTime;

    @Column(name = "upd_time")
    @ApiModelProperty(value = "修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updTime;

}
