package com.xxfc.platform.summit.controller;


import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.summit.biz.ActivityBmBiz;
import com.xxfc.platform.summit.biz.UserBiz;
import com.xxfc.platform.summit.entity.ActivityBm;
import com.xxfc.platform.summit.entity.User;
import com.xxfc.platform.summit.pojo.ActivityBmQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("/activityBm")
public class ActivityBmController extends BaseController<ActivityBmBiz,ActivityBm> {


    @Autowired
    UserBiz userBiz;


    @PostMapping("/add")
    public ObjectRestResponse bm(@RequestBody ActivityBm activityBm, HttpServletRequest request){
        User user=userBiz.getSession(request);
        try {
            return ObjectRestResponse.succ(baseBiz.userBm(activityBm,user.getId()));
        }catch (Exception e){
            e.printStackTrace();
            return  ObjectRestResponse.createDefaultFail();
        }

    }


    @PostMapping("/list")
    public ObjectRestResponse getList( @RequestBody ActivityBmQuery query ){
        return ObjectRestResponse.succ(baseBiz.list(query));
    }


}
