package com.xxfc.platform.summit.config;


import com.github.wxiaoqi.security.common.handler.GlobalExceptionHandler;
import com.xxfc.platform.summit.interceptor.WeChatH5LoginInterceoptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import java.util.ArrayList;
import java.util.Collections;

@Configuration("summitWebConfig")
@Primary
public class WebConfiguration implements WebMvcConfigurer {

    @Bean
    GlobalExceptionHandler getGlobalExceptionHandler() {
        return new GlobalExceptionHandler();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(getWeChatH5LoginRestInterceptor()).
                addPathPatterns(getIncludePathPatterns());
    }

    @Bean
    WeChatH5LoginInterceoptor  getWeChatH5LoginRestInterceptor() {
        return new WeChatH5LoginInterceoptor();
    }

    /**
     * 需要用户和服务认证判断的路径
     * @return
     */
    private ArrayList<String> getIncludePathPatterns() {
        ArrayList<String> list = new ArrayList<>();
        String[] urls = {
                "/activity/**"
        };
        Collections.addAll(list, urls);
        return list;
    }
}
